close all;

figure
plot(T,MAX,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('J=f(x,y)','FontSize',18,'FontWeight','bold');
title('Output','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([0 100 -2 1.2]);
saveas(gcf,'ps_moving_output.eps','psc2');
axis([0 35 -2 1.2]);
saveas(gcf,'ps_moving_output_new.eps','psc2');


figure
plot(X,Y,'LineWidth',1);
hold on;
plot(centerx, centery,'r--','LineWidth',2);
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
%title('Vehicle Trajectory','FontSize',18,'FontWeight','bold');
title('Vehicle Trajectory for Moving Source','FontSize',18,'FontWeight','bold');
legend('vehicle trajectory','source trajectory')
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([-1.5 1.5 -2.5 2.5]);
saveas(gcf,'ps_moving_trajectory.eps','psc2');


figure
plot(T,Vx,'LineWidth',1);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('U_x','FontSize',18,'FontWeight','bold');
title('Control Input of X-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'ps_moving_vx.eps','psc2');
axis([0 35 -80 100]);
saveas(gcf,'ps_moving_vx_new.eps','psc2');


figure
plot(T,Vy,'LineWidth',1);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('U_y','FontSize',18,'FontWeight','bold');
title('Control Input of Y-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'ps_moving_vy.eps','psc2');
axis([0 35 -100 100]);
saveas(gcf,'ps_moving_vy_new.eps','psc2');
